<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

header('Content-Type: application/json');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit();
}

// Get the search term
$term = isset($_GET['term']) ? trim($_GET['term']) : '';

if (empty($term)) {
    echo json_encode(['success' => false, 'message' => 'No search term provided']);
    exit();
}

try {
    // Search clients by name, email, or phone
    $stmt = $pdo->prepare("
        SELECT * FROM customers 
        WHERE name LIKE ? 
        OR email LIKE ? 
        OR phone LIKE ?
        ORDER BY name 
        LIMIT 10
    ");
    
    $searchTerm = "%{$term}%";
    $stmt->execute([$searchTerm, $searchTerm, $searchTerm]);
    $clients = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Log the results for debugging
    error_log("Search term: " . $term);
    error_log("Found clients: " . count($clients));

    echo json_encode([
        'success' => true,
        'clients' => $clients
    ]);
} catch (PDOException $e) {
    error_log("Database error in search_clients.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} 